-- Filename: ahb_multilayer_detect_request_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed Oct 15 18:45:21 2025
architecture struct of ahb_multilayer_detect_request is
    signal last_access_had_lock    : std_logic_vector (g_number_of_masters-1 downto 0);
    signal use_last_grant_at_burst : std_logic_vector (g_number_of_masters-1 downto 0);
    signal use_last_grant_at_lock  : std_logic_vector (g_number_of_masters-1 downto 0);
begin
    process(hsel_i, hcontrol_i)
    begin
        for i in 0 to g_number_of_masters-1 loop
            -- "NONSEQ", "SEQ", "BUSY" and
            -- "IDLE with hmastlock active" request the bus:
            request_o(i) <= hsel_i(i) and (hcontrol_i(i).htrans(1) or
                                           hcontrol_i(i).htrans(0) or
                                           hcontrol_i(i).hmastlock);
            -- "BUSY" or "SEQ" or hmastlock=1 disable arbitration:
            use_last_grant_at_burst(i) <= hsel_i(i) and hcontrol_i(i).htrans(0);
        end loop;
    end process;
    -- Activate the lock after the first access:
    process(hresetn_i, hclk_i)
    begin
        if hresetn_i='0' then
            last_access_had_lock <= (others => '0');
        elsif rising_edge(hclk_i) then
            if hready_i='1' then
                for i in 0 to g_number_of_masters-1 loop
                    last_access_had_lock(i) <= grant_i(i) and hsel_i(i) and hcontrol_i(i).hmastlock;
                end loop;
            end if;
        end if;
    end process;
    -- Deactivate the lock immediately when hmastlock=0:
    process(last_access_had_lock, hcontrol_i)
    begin
        for i in 0 to g_number_of_masters-1 loop
            use_last_grant_at_lock(i) <= last_access_had_lock(i) and hcontrol_i(i).hmastlock;
        end loop;
    end process;
    use_last_grant_o <= use_last_grant_at_burst or
                        use_last_grant_at_lock;
end architecture;
