-- Filename: ahb_multilayer_decoder_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed Oct 15 18:45:23 2025
architecture struct of ahb_multilayer_decoder is
    signal hsel : std_logic_vector(g_number_of_slaves-1 downto 0);
begin
    process(hcontrol_i)
    begin
        hsel <= (others => '0');
        for i in 0 to g_number_of_slaves-1 loop
            if hcontrol_i.haddr    (g_addr_width-1 downto g_slave_address_width(i))=
               g_start_addresses(i)(g_addr_width-1 downto g_slave_address_width(i)) then
                hsel(i) <= '1';
            end if;
        end loop;
    end process;
    hsel_o <= hsel;
    process(hsel, hcontrol_i)
    begin
        create_err_response_o <= '0';
        if hsel=(g_number_of_slaves-1 downto 0 => '0') then
            -- haddr does not select any slave:
            if hcontrol_i.htrans(1)='1' then -- NONSEQ or SEQ (BUSY and IDLE are no transfers)
                create_err_response_o <= '1';
            end if;
        end if;
    end process;
end architecture;
