-- Filename: testbench_ahb_apb_bridge_struct.vhd
-- Created by HDL-SCHEM-Editor at Tue Dec  2 17:52:56 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
architecture struct of testbench_ahb_apb_bridge is
    constant c_period                  : time     := 10 ns;
    constant c_endianness              : positive := 1;
    constant c_number_of_apb_slaves    : positive := 2;
    constant c_addr_width              : positive := 16;
    constant c_data_width              : positive := 32;
    constant c_hburst_width            : natural  := 3;
    constant c_hprot_width             : natural  := 4;
    constant c_apb_slave_address_width : t_positive_list(0 to c_number_of_apb_slaves-1) := (12, 8);
    constant c_apb_start_addresses     : t_std_logic_vector_list(0 to c_number_of_apb_slaves-1)(c_addr_width-1 downto 0) := (X"1000", X"3400");
    signal hcontrol         : t_ahb_control  (haddr(c_addr_width-1 downto 0),hburst(c_hburst_width-1 downto 0), hprot(c_hprot_width-1 downto 0));
    signal hrdata           : std_logic_vector (c_data_width-1 downto 0);
    signal hready           : std_logic;
    signal hreadyout        : std_logic;
    signal hresp            : std_logic;
    signal hsel             : std_logic;
    signal hwdata           : std_logic_vector (c_data_width-1 downto 0);
    signal paddr            : std_logic_vector (c_addr_width-1 downto 0);
    signal pclk             : std_logic := '0';
    signal penable          : std_logic;
    signal pprot            : std_logic_vector (2 downto 0);
    signal prdata           : t_std_logic_vector_list (c_number_of_apb_slaves-1 downto 0)(c_data_width-1 downto 0);
    signal pready           : std_logic_vector (c_number_of_apb_slaves-1 downto 0);
    signal presetn          : std_logic;
    signal psel             : std_logic_vector (c_number_of_apb_slaves-1 downto 0);
    signal pslverr          : std_logic_vector (c_number_of_apb_slaves-1 downto 0);
    signal pstrb            : std_logic_vector (c_data_width/8-1 downto 0);
    signal pwdata           : std_logic_vector (c_data_width-1 downto 0);
    signal pwrite           : std_logic;
    signal run_simulation   : std_logic := '1';
    signal stimulation_runs : std_logic := '1';
    component ahb_slave_interface is
        generic (
            g_period                  : time     := 10 ns;
            g_addr_width              : natural  := 32;
            g_data_width              : natural  := 32;
            g_hburst_width            : natural  :=  3;
            g_hprot_width             : natural  :=  4;
            g_number_of_apb_slaves    : positive := 2;
            g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (12, 8);
            g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (x"00001000", x"00003400") 
        );
        port (
            hrdata_i           : in  std_logic_vector (g_data_width-1 downto 0) ;
            hreadyout_i        : in  std_logic  ;
            hresp_i            : in  std_logic  ;
            hcontrol_o         : out t_ahb_control  (haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_o           : out std_logic  ;
            hsel_o             : out std_logic  ;
            hwdata_o           : out std_logic_vector (g_data_width-1 downto 0) ;
            stimulation_runs_o : out std_logic  
        );
    end component;
    component ahb_apb_bridge is
        generic (
            g_endianness              : positive := 1;
            g_number_of_apb_slaves    : positive := 2;
            g_addr_width              : positive := 32;
            g_data_width              : positive := 32;
            g_hburst_width            : natural  := 3;
            g_hprot_width             : natural  := 4;
            g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (12, 8);
            g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (x"00001000", x"00003400") 
        );
        port (
            hcontrol_i  : in  t_ahb_control  (haddr(g_addr_width-1 downto 0),hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_i    : in  std_logic  ;
            hsel_i      : in  std_logic  ;
            hwdata_i    : in  std_logic_vector (g_data_width-1 downto 0) ;
            pclk_i      : in  std_logic  ;
            prdata_i    : in  t_std_logic_vector_list (g_number_of_apb_slaves-1 downto 0)(g_data_width-1 downto 0) ;
            pready_i    : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            presetn_i   : in  std_logic  ;
            pslverr_i   : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            hrdata_o    : out std_logic_vector (g_data_width-1 downto 0) ;
            hreadyout_o : out std_logic  ;
            hresp_o     : out std_logic  ;
            paddr_o     : out std_logic_vector (g_addr_width-1 downto 0) ;
            penable_o   : out std_logic  ;
            pprot_o     : out std_logic_vector (2 downto 0) ;
            psel_o      : out std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            pstrb_o     : out std_logic_vector (g_data_width/8-1 downto 0) ;
            pwdata_o    : out std_logic_vector (g_data_width-1 downto 0) ;
            pwrite_o    : out std_logic  
        );
    end component;
    component apb_slave is
        generic (
            g_apb_slave_index         : natural := 0;
            g_endianness              : positive := 1;
            g_addr_width              : positive := 32;
            g_data_width              : positive := 32;
            g_apb_slave_address_width : positive := 10;
            g_apb_start_address       : std_logic_vector(g_addr_width-1 downto 0)
        );
        port (
            paddr_i   : in  std_logic_vector (g_addr_width-1 downto 0) ;
            pclk_i    : in  std_logic  ;
            penable_i : in  std_logic  ;
            pprot_i   : in  std_logic_vector (2 downto 0) ;
            presetn_i : in  std_logic  ;
            psel_i    : in  std_logic  ;
            pstrb_i   : in  std_logic_vector (g_data_width/8-1 downto 0) ;
            pwdata_i  : in  std_logic_vector (g_data_width-1 downto 0) ;
            pwrite_i  : in  std_logic  ;
            prdata_o  : out std_logic_vector (g_data_width-1 downto 0) ;
            pready_o  : out std_logic  ;
            pslverr_o : out std_logic  
        );
    end component;
begin
    process
    begin
        for i in 0 to c_number_of_apb_slaves-1 loop
            assert c_apb_slave_address_width(i)<c_addr_width report
                   "Error: slave-address-width " & integer'image(c_apb_slave_address_width(i)) &
                   " is not smaller than master-address-width " & integer'image(c_addr_width) severity error;
        end loop;
        wait for c_period;
        while stimulation_runs='1' loop
            wait for c_period;
        end loop;
        run_simulation <= '0';
        wait;
    end process;
    presetn <= '0', '1' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            pclk <= not pclk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    ahb_slave_interface_inst : ahb_slave_interface
        generic map (
            g_period => c_period,
            g_number_of_apb_slaves    => c_number_of_apb_slaves,
            g_addr_width              => c_addr_width,
            g_data_width              => c_data_width,
            g_hburst_width            => c_hburst_width,
            g_hprot_width             => c_hprot_width,
            g_apb_slave_address_width => c_apb_slave_address_width,
            g_apb_start_addresses     => c_apb_start_addresses
        )
        port map (
            hrdata_i           => hrdata,
            hreadyout_i        => hreadyout,
            hresp_i            => hresp,
            hcontrol_o         => hcontrol,
            hready_o           => hready,
            hsel_o             => hsel,
            hwdata_o           => hwdata,
            stimulation_runs_o => stimulation_runs
        );
    ahb_apb_bridge_inst : ahb_apb_bridge
        generic map (
            g_endianness              => c_endianness,
            g_number_of_apb_slaves    => c_number_of_apb_slaves,
            g_addr_width              => c_addr_width,
            g_data_width              => c_data_width,
            g_hburst_width            => c_hburst_width,
            g_hprot_width             => c_hprot_width,
            g_apb_slave_address_width => c_apb_slave_address_width,
            g_apb_start_addresses     => c_apb_start_addresses
        )
        port map (
            hcontrol_i  => hcontrol,
            hready_i    => hready,
            hsel_i      => hsel,
            hwdata_i    => hwdata,
            pclk_i      => pclk,
            prdata_i    => prdata,
            pready_i    => pready,
            presetn_i   => presetn,
            pslverr_i   => pslverr,
            hrdata_o    => hrdata,
            hreadyout_o => hreadyout,
            hresp_o     => hresp,
            paddr_o     => paddr,
            penable_o   => penable,
            pprot_o     => pprot,
            psel_o      => psel,
            pstrb_o     => pstrb,
            pwdata_o    => pwdata,
            pwrite_o    => pwrite
        );
    apb_slave_g: for i in 0 to c_number_of_apb_slaves-1 generate
        apb_slave_inst : apb_slave
            generic map (
                g_apb_slave_index         => i,
                g_endianness              => c_endianness,
                g_addr_width              => c_addr_width,
                g_data_width              => c_data_width,
                g_apb_slave_address_width => c_apb_slave_address_width(i),
                g_apb_start_address       => c_apb_start_addresses(i)
            )
            port map (
                paddr_i   => paddr,
                pclk_i    => pclk,
                penable_i => penable,
                pprot_i   => pprot,
                presetn_i => presetn,
                psel_i    => psel(i),
                pstrb_i   => pstrb,
                pwdata_i  => pwdata,
                pwrite_i  => pwrite,
                prdata_o  => prdata(i),
                pready_o  => pready(i),
                pslverr_o => pslverr(i)
            );
    end generate apb_slave_g;
end architecture;
