-- Filename: apb_slave_e.vhd
-- Created by HDL-FSM-Editor at Tue Dec  2 17:47:51 2025
library ieee;
use ieee.std_logic_1164.all;

entity apb_slave is
    generic (
        g_apb_slave_index         : natural := 0;
        g_endianness              : positive := 1;
        g_addr_width              : positive := 32;
        g_data_width              : positive := 32;
        g_apb_slave_address_width : positive := 10;
        g_apb_start_address       : std_logic_vector(g_addr_width-1 downto 0) 
    );
    port (
        presetn_i : in std_logic;
        pclk_i    : in std_logic;
        psel_i    : in std_logic;
        pwrite_i  : in std_logic;
        penable_i : in std_logic;
        pprot_i   : in std_logic_vector(2 downto 0);
        paddr_i   : in std_logic_vector(g_addr_width-1 downto 0);
        pwdata_i  : in std_logic_vector(g_data_width-1 downto 0);
        pstrb_i   : in std_logic_vector(g_data_width/8-1 downto 0);
        pready_o  : out std_logic;
        pslverr_o : out std_logic;
        prdata_o  : out std_logic_vector(g_data_width-1 downto 0) 
    );
end entity;
