-- Filename: testbench_ahb_apb_bridge_synthesis_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed Dec  3 10:05:49 2025
architecture struct of testbench_ahb_apb_bridge_synthesis is
    constant c_master_idle : t_ahb_control := (
            haddr     => (g_addr_width-1 downto 0 => '0'),
            hwrite    => '0',
            hsize     => "000",
            hburst    => (g_hburst_width-1 downto 0 => '0'),
            hprot     => (g_hprot_width-1 downto 0 => '0'),
            htrans    => "00",
            hmastlock => '0');
    signal hcontrol  : t_ahb_control  (haddr(g_addr_width-1 downto 0),hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
    signal hrdata    : std_logic_vector (g_data_width-1 downto 0);
    signal hready    : std_logic;
    signal hreadyout : std_logic;
    signal hresp     : std_logic;
    signal hsel      : std_logic;
    signal hwdata    : std_logic_vector (g_data_width-1 downto 0);
    signal paddr     : std_logic_vector (g_addr_width-1 downto 0);
    signal penable   : std_logic;
    signal pprot     : std_logic_vector (2 downto 0);
    signal prdata    : t_std_logic_vector_list (g_number_of_apb_slaves-1 downto 0)(g_data_width-1 downto 0);
    signal pready    : std_logic_vector (g_number_of_apb_slaves-1 downto 0);
    signal psel      : std_logic_vector (g_number_of_apb_slaves-1 downto 0);
    signal pslverr   : std_logic_vector (g_number_of_apb_slaves-1 downto 0);
    signal pstrb     : std_logic_vector (g_data_width/8-1 downto 0);
    signal pwdata    : std_logic_vector (g_data_width-1 downto 0);
    signal pwrite    : std_logic;
    component ahb_apb_bridge is
        generic (
            g_endianness              : positive := 1;
            g_number_of_apb_slaves    : positive := 2;
            g_addr_width              : positive := 32;
            g_data_width              : positive := 32;
            g_hburst_width            : natural  := 3;
            g_hprot_width             : natural  := 4;
            g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (12, 8);
            g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (x"00001000", x"00003400") 
        );
        port (
            hcontrol_i  : in  t_ahb_control  (haddr(g_addr_width-1 downto 0),hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_i    : in  std_logic  ;
            hsel_i      : in  std_logic  ;
            hwdata_i    : in  std_logic_vector (g_data_width-1 downto 0) ;
            pclk_i      : in  std_logic  ;
            prdata_i    : in  t_std_logic_vector_list (g_number_of_apb_slaves-1 downto 0)(g_data_width-1 downto 0) ;
            pready_i    : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            presetn_i   : in  std_logic  ;
            pslverr_i   : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            hrdata_o    : out std_logic_vector (g_data_width-1 downto 0) ;
            hreadyout_o : out std_logic  ;
            hresp_o     : out std_logic  ;
            paddr_o     : out std_logic_vector (g_addr_width-1 downto 0) ;
            penable_o   : out std_logic  ;
            pprot_o     : out std_logic_vector (2 downto 0) ;
            psel_o      : out std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            pstrb_o     : out std_logic_vector (g_data_width/8-1 downto 0) ;
            pwdata_o    : out std_logic_vector (g_data_width-1 downto 0) ;
            pwrite_o    : out std_logic  
        );
    end component;
begin
    process(presetn_i, pclk_i)
    begin
        if presetn_i='0' then
            pready   <= (others => '0');
            pslverr  <= (others => '0');
            prdata   <= (others => (others => '0'));
            hcontrol <= c_master_idle;
            hwdata   <= (others => '0');
            hready   <= '0';
            hsel     <= '0';
        elsif rising_edge(pclk_i) then
            pready   <= pready_i;
            pslverr  <= pslverr_i;
            prdata   <= prdata_i;
            hcontrol <= hcontrol_i;
            hwdata   <= hwdata_i;
            hready   <= hready_i;
            hsel     <= hsel_i;
        end if;
    end process;
    process(presetn_i, pclk_i)
    begin
        if presetn_i='0' then
            pwdata_o    <= (others => '0');
            pwrite_o    <= '0';
            penable_o   <= '0';
            paddr_o     <= (others => '0');
            psel_o      <= (others => '0');
            pprot_o     <= (others => '0');
            pstrb_o     <= (others => '0');
            hresp_o     <= '0';
            hrdata_o    <= (others => '0');
            hreadyout_o <= '0';
        elsif rising_edge(pclk_i) then
            pwdata_o    <= pwdata;
            pwrite_o    <= pwrite;
            penable_o   <= penable;
            paddr_o     <= paddr;
            psel_o      <= psel;
            pprot_o     <= pprot;
            pstrb_o     <= pstrb;
            hresp_o     <= hresp;
            hrdata_o    <= hrdata;
            hreadyout_o <= hreadyout;
        end if;
    end process;
    ahb_apb_bridge_inst : ahb_apb_bridge
        generic map (
            g_endianness              => g_endianness,
            g_number_of_apb_slaves    => g_number_of_apb_slaves,
            g_addr_width              => g_addr_width,
            g_data_width              => g_data_width,
            g_hburst_width            => g_hburst_width,
            g_hprot_width             => g_hprot_width,
            g_apb_slave_address_width => g_apb_slave_address_width,
            g_apb_start_addresses     => g_apb_start_addresses
        )
        port map (
            hcontrol_i  => hcontrol,
            hready_i    => hready,
            hsel_i      => hsel,
            hwdata_i    => hwdata,
            pclk_i      => pclk_i,
            prdata_i    => prdata,
            pready_i    => pready,
            presetn_i   => presetn_i,
            pslverr_i   => pslverr,
            hrdata_o    => hrdata,
            hreadyout_o => hreadyout,
            hresp_o     => hresp,
            paddr_o     => paddr,
            penable_o   => penable,
            pprot_o     => pprot,
            psel_o      => psel,
            pstrb_o     => pstrb,
            pwdata_o    => pwdata,
            pwrite_o    => pwrite
        );
end architecture;
