-- Filename: testbench_ahb_apb_bridge_synthesis_e.vhd
-- Created by HDL-SCHEM-Editor at Wed Dec  3 10:05:49 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity testbench_ahb_apb_bridge_synthesis is
    generic (
        g_endianness              : positive :=  1;
        g_number_of_masters       : positive :=  3;
        g_number_of_apb_slaves    : positive :=  2;
        g_addr_width              : positive := 16;
        g_hburst_width            : natural  :=  3;
        g_hprot_width             : natural  :=  4;
        g_data_width              : positive := 16;
        g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (12, 8);
        g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (X"1000", X"3400")
    );
    port (
        hcontrol_i  : in  t_ahb_control  (haddr(g_addr_width-1 downto 0),hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hready_i    : in  std_logic;
        hsel_i      : in  std_logic;
        hwdata_i    : in  std_logic_vector (g_data_width-1 downto 0);
        pclk_i      : in  std_logic;
        prdata_i    : in  t_std_logic_vector_list (g_number_of_apb_slaves-1 downto 0)(g_data_width-1 downto 0);
        pready_i    : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0);
        presetn_i   : in  std_logic;
        pslverr_i   : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0);
        hrdata_o    : out std_logic_vector (g_data_width-1 downto 0);
        hreadyout_o : out std_logic;
        hresp_o     : out std_logic;
        paddr_o     : out std_logic_vector (g_addr_width-1 downto 0);
        penable_o   : out std_logic;
        pprot_o     : out std_logic_vector (2 downto 0);
        psel_o      : out std_logic_vector (g_number_of_apb_slaves-1 downto 0);
        pstrb_o     : out std_logic_vector (g_data_width/8-1 downto 0);
        pwdata_o    : out std_logic_vector (g_data_width-1 downto 0);
        pwrite_o    : out std_logic
    );
end entity testbench_ahb_apb_bridge_synthesis;
