-- Filename: apb_slave_fsm.vhd
-- Created by HDL-FSM-Editor at Tue Dec  2 17:47:51 2025
library ieee;
use ieee.numeric_std.all;

architecture fsm of apb_slave is
    type t_state is (setup, active, pause);
    signal state : t_state;
begin
    p_states: process (presetn_i, pclk_i)
        variable hsize : std_logic_vector(2 downto 0);
    begin
        if presetn_i='0' then
            state <= setup;
            prdata_o <= (others => '0');
        elsif rising_edge(pclk_i) then
            -- State Machine:
            case state is
                when setup =>
                    if psel_i='1' and
                       penable_i='0'
                    then
                        assert paddr_i=pwdata_i(paddr_i'range)
                               report "paddr or pwdata is wrong in slave " & integer'image(g_apb_slave_index) severity error;
                        assert pwrite_i=pwdata_i(24)
                               report "pwrite or pwdata(24) is wrong in slave " & integer'image(g_apb_slave_index) severity error;
                        assert paddr_i(g_addr_width-1 downto g_apb_slave_address_width)=g_apb_start_address(g_addr_width-1 downto g_apb_slave_address_width)
                               report "address is not allowed to activate psel in slave " & integer'image(g_apb_slave_index) severity error;
                        hsize := pwdata_i(30 downto 28);
                        if g_endianness=1 then
                        assert (g_data_width/8=1 and pstrb_i(0)='1') or 
                               (g_data_width/8=2 and hsize="000" and paddr_i(0)='0' and pstrb_i="01") or
                               (g_data_width/8=2 and hsize="000" and paddr_i(0)='1' and pstrb_i="10") or
                               (g_data_width/8=2 and hsize="001" and paddr_i(0)='0' and pstrb_i="11") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="00" and pstrb_i="0001") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="01" and pstrb_i="0010") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="10" and pstrb_i="0100") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="11" and pstrb_i="1000") or
                               (g_data_width/8=4 and hsize="001" and paddr_i(1 downto 0)="00" and pstrb_i="0011") or
                               (g_data_width/8=4 and hsize="001" and paddr_i(1 downto 0)="10" and pstrb_i="1100") or
                               (g_data_width/8=4 and hsize="010" and paddr_i(1 downto 0)="00" and pstrb_i="1111") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="000" and pstrb_i="00000001") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="001" and pstrb_i="00000010") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="010" and pstrb_i="00000100") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="011" and pstrb_i="00001000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="100" and pstrb_i="00010000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="101" and pstrb_i="00100000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="110" and pstrb_i="01000000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="111" and pstrb_i="10000000") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="000" and pstrb_i="00000011") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="010" and pstrb_i="00001100") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="100" and pstrb_i="00110000") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="110" and pstrb_i="11000000") or
                               (g_data_width/8=8 and hsize="010" and paddr_i(2 downto 0)="000" and pstrb_i="00001111") or
                               (g_data_width/8=8 and hsize="010" and paddr_i(2 downto 0)="100" and pstrb_i="11110000") or
                               (g_data_width/8=8 and hsize="011" and paddr_i(2 downto 0)="000" and pstrb_i="11111111")
                                report "Error in pstrb_i in slave " & integer'image(g_apb_slave_index) severity error;
                        else
                        assert (g_data_width/8=1 and pstrb_i(0)='1') or 
                               (g_data_width/8=2 and hsize="000" and paddr_i(0)='0' and pstrb_i="10") or
                               (g_data_width/8=2 and hsize="000" and paddr_i(0)='1' and pstrb_i="01") or
                               (g_data_width/8=2 and hsize="001" and paddr_i(0)='0' and pstrb_i="11") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="00" and pstrb_i="1000") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="01" and pstrb_i="0100") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="10" and pstrb_i="0010") or
                               (g_data_width/8=4 and hsize="000" and paddr_i(1 downto 0)="11" and pstrb_i="0001") or
                               (g_data_width/8=4 and hsize="001" and paddr_i(1 downto 0)="00" and pstrb_i="1100") or
                               (g_data_width/8=4 and hsize="001" and paddr_i(1 downto 0)="10" and pstrb_i="0011") or
                               (g_data_width/8=4 and hsize="010" and paddr_i(1 downto 0)="00" and pstrb_i="1111") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="000" and pstrb_i="10000000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="001" and pstrb_i="01000000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="010" and pstrb_i="00100000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="011" and pstrb_i="00010000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="100" and pstrb_i="00001000") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="101" and pstrb_i="00000100") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="110" and pstrb_i="00000010") or
                               (g_data_width/8=8 and hsize="000" and paddr_i(2 downto 0)="111" and pstrb_i="00000001") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="000" and pstrb_i="11000000") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="010" and pstrb_i="00110000") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="100" and pstrb_i="00001100") or
                               (g_data_width/8=8 and hsize="001" and paddr_i(2 downto 0)="110" and pstrb_i="00000011") or
                               (g_data_width/8=8 and hsize="010" and paddr_i(2 downto 0)="000" and pstrb_i="11110000") or
                               (g_data_width/8=8 and hsize="010" and paddr_i(2 downto 0)="100" and pstrb_i="00001111") or
                               (g_data_width/8=8 and hsize="011" and paddr_i(2 downto 0)="000" and pstrb_i="11111111")
                                report "Error in pstrb_i in slave " & integer'image(g_apb_slave_index) severity error;
                        end if;
                        if paddr_i(0)='0' then
                            prdata_o                <= (others => '0');
                            prdata_o(paddr_i'range) <= paddr_i;
                            prdata_o(20)            <= pwrite_i;
                            prdata_o(26 downto 24)  <= pprot_i;
                            prdata_o(31 downto 28)  <= std_logic_vector(to_unsigned(g_apb_slave_index, 4));
                            state <= active;
                        else
                            state <= pause;
                        end if;
                    end if;
                when active =>
                    if penable_i='1' then
                        state <= setup;
                    end if;
                when pause =>
                    if penable_i='1' then
                        prdata_o                <= (others => '0');
                        prdata_o(paddr_i'range) <= paddr_i;
                        prdata_o(20)            <= pwrite_i;
                        prdata_o(26 downto 24)  <= pprot_i;
                        prdata_o(31 downto 28)  <= std_logic_vector(to_unsigned(g_apb_slave_index, 4));
                        state <= active;
                    end if;
            end case;
        end if;
    end process;
    p_state_actions: process (paddr_i, state)
    begin
        -- State Actions:
        case state is
            when setup=>
                pready_o  <= 'X'; -- slaves are allowed to set pready to 0 or to 1 in setup
                pslverr_o <= 'X'; -- only valid when pready_o=1
            when active=>
                pready_o <= '1';
                if paddr_i(2 downto 0)/="110" then
                    pslverr_o <= '0';
                else
                    pslverr_o <= '1';
                end if;
            when pause=>
                pready_o <= '0';
                pslverr_o <= '0';
        end case;
    end process;
end architecture;
