-- Filename: ahb_slave_interface_e.vhd
-- Created by HDL-SCHEM-Editor at Tue Dec  2 18:11:30 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;
entity ahb_slave_interface is
    generic (
        g_period                  : time     := 10 ns;
        g_addr_width              : natural  := 32;
        g_data_width              : natural  := 32;
        g_hburst_width            : natural  :=  3;
        g_hprot_width             : natural  :=  4;
        g_number_of_apb_slaves    : positive := 2;
        g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (12, 8);
        g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (X"00001000", X"00003400") 
    );
    port (
        hrdata_i           : in  std_logic_vector(g_data_width-1 downto 0);
        hreadyout_i        : in  std_logic;
        hresp_i            : in  std_logic;
        hcontrol_o         : out t_ahb_control(haddr(g_addr_width-1 downto 0), hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hready_o           : out std_logic;
        hsel_o             : out std_logic;
        hwdata_o           : out std_logic_vector(g_data_width-1 downto 0);
        stimulation_runs_o : out std_logic
    );
end entity ahb_slave_interface;
