-- Filename: ahb_apb_bridge_struct.vhd
-- Created by HDL-SCHEM-Editor at Tue Dec  2 18:18:45 2025
architecture struct of ahb_apb_bridge is
    signal pready_sel  : std_logic;
    signal psel        : std_logic_vector (g_number_of_apb_slaves-1 downto 0);
    signal pslverr_sel : std_logic;
    component ahb_apb_bridge_access_handler is
        generic (
            g_endianness              : positive := 1;
            g_addr_width              : positive := 32;
            g_data_width              : positive := 32;
            g_hburst_width            : natural  := 3;
            g_hprot_width             : natural  := 4;
            g_number_of_apb_slaves    : positive := 2;
            g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (16, 8);
            g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (x"0000_0000", x"0002_0000")
        );
        port (
            hcontrol_i    : in  t_ahb_control  (haddr(g_addr_width-1 downto 0),hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
            hready_i      : in  std_logic  ;
            hsel_i        : in  std_logic  ;
            pclk_i        : in  std_logic  ;
            pready_sel_i  : in  std_logic  ;
            presetn_i     : in  std_logic  ;
            pslverr_sel_i : in  std_logic  ;
            hreadyout_o   : out std_logic  ;
            hresp_o       : out std_logic  ;
            paddr_o       : out std_logic_vector (g_addr_width-1 downto 0) ;
            penable_o     : out std_logic  ;
            pprot_o       : out std_logic_vector (2 downto 0) ;
            psel_o        : out std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            pstrb_o       : out std_logic_vector (g_data_width/8-1 downto 0) ;
            pwrite_o      : out std_logic  
        );
    end component;
    component ahb_apb_bridge_mux is
        generic (
            g_number_of_apb_slaves : positive := 3;
            g_data_width   : positive := 32 
        );
        port (
            prdata_i      : in  t_std_logic_vector_list (g_number_of_apb_slaves-1 downto 0)(g_data_width-1 downto 0) ;
            pready_i      : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            psel_i        : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            pslverr_i     : in  std_logic_vector (g_number_of_apb_slaves-1 downto 0) ;
            hrdata_o      : out std_logic_vector (g_data_width-1 downto 0) ;
            pready_sel_o  : out std_logic  ;
            pslverr_sel_o : out std_logic  
        );
    end component;
begin
    ahb_apb_bridge_access_handler_inst : ahb_apb_bridge_access_handler
        generic map (
            g_endianness              => g_endianness,
            g_addr_width              => g_addr_width,
            g_data_width              => g_data_width,
            g_hburst_width            => g_hburst_width,
            g_hprot_width             => g_hprot_width,
            g_number_of_apb_slaves    => g_number_of_apb_slaves,
            g_apb_slave_address_width => g_apb_slave_address_width,
            g_apb_start_addresses     => g_apb_start_addresses
        )
        port map (
            hcontrol_i    => hcontrol_i,
            hready_i      => hready_i,
            hsel_i        => hsel_i,
            pclk_i        => pclk_i,
            pready_sel_i  => pready_sel,
            presetn_i     => presetn_i,
            pslverr_sel_i => pslverr_sel,
            hreadyout_o   => hreadyout_o,
            hresp_o       => hresp_o,
            paddr_o       => paddr_o,
            penable_o     => penable_o,
            pprot_o       => pprot_o,
            psel_o        => psel,
            pstrb_o       => pstrb_o,
            pwrite_o      => pwrite_o
        );
    psel_o <= psel;
    pwdata_o <= hwdata_i;
    ahb_apb_bridge_mux_inst : ahb_apb_bridge_mux
        generic map (
            g_number_of_apb_slaves => g_number_of_apb_slaves,
            g_data_width           => g_data_width 
        )
        port map (
            prdata_i      => prdata_i,
            pready_i      => pready_i,
            psel_i        => psel,
            pslverr_i     => pslverr_i,
            hrdata_o      => hrdata_o,
            pready_sel_o  => pready_sel,
            pslverr_sel_o => pslverr_sel
        );
end architecture;
