-- Filename: ahb_apb_bridge_mux_struct.vhd
-- Created by HDL-SCHEM-Editor
architecture struct of ahb_apb_bridge_mux is
begin
    -- Multiplexer:
    -- This circuit differs from a multiplexer in that it
    -- always outputs zeros when no input is selected.
    process(psel_i, prdata_i, pslverr_i, pready_i)
        variable prdata_sel_v  : std_logic_vector(g_data_width-1 downto 0);
        variable prdata_sel    : std_logic_vector(g_data_width-1 downto 0);
        variable pslverr_sel_v : std_logic;
        variable pslverr_sel   : std_logic;
        variable pready_sel_v  : std_logic;
        variable pready_sel    : std_logic;
    begin
        prdata_sel  := (others => '0');
        pslverr_sel := '0';
        pready_sel  := '0';
        for i in 0 to g_number_of_apb_slaves-1 loop
            if psel_i(i)='0' then
                prdata_sel_v  := (others => '0');
                pslverr_sel_v := '0';
                pready_sel_v  := '0';
            else
                prdata_sel_v  := prdata_i(i);
                pslverr_sel_v := pslverr_i(i);
                pready_sel_v  := pready_i(i);
            end if;
            prdata_sel  := prdata_sel  or prdata_sel_v;
            pslverr_sel := pslverr_sel or pslverr_sel_v;
            pready_sel  := pready_sel  or pready_sel_v;
        end loop;
        hrdata_o      <= prdata_sel;
        pslverr_sel_o <= pslverr_sel;
        pready_sel_o  <= pready_sel;
    end process;
end architecture;
