-- Filename: ahb_apb_bridge_access_handler_e.vhd
-- Created by HDL-FSM-Editor at Tue Dec  2 19:02:16 2025
library ieee;
use ieee.std_logic_1164.all;
use work.ahb_package.all;

entity ahb_apb_bridge_access_handler is
    generic (
        g_endianness              : positive := 1;
        g_addr_width              : positive := 32;
        g_data_width              : positive := 32;
        g_hburst_width            : natural  := 3;
        g_hprot_width             : natural  := 4;
        g_number_of_apb_slaves    : positive := 2;
        g_apb_slave_address_width : t_positive_list(0 to g_number_of_apb_slaves-1) := (16, 8);
        g_apb_start_addresses     : t_std_logic_vector_list(0 to g_number_of_apb_slaves-1)(g_addr_width-1 downto 0) := (x"0000_0000", x"0002_0000") 
    );
    port (
        presetn_i  : in  std_logic;
        pclk_i     : in  std_logic;
        -- AHB interface:
        hsel_i     : in  std_logic;
        hready_i   : in  std_logic;
        hcontrol_i : in  t_ahb_control(haddr(g_addr_width-1 downto 0),hburst(g_hburst_width-1 downto 0), hprot(g_hprot_width-1 downto 0));
        hreadyout_o: out std_logic;
        hresp_o    : out std_logic;
        -- APB interface:
        psel_o     : out std_logic_vector(g_number_of_apb_slaves-1 downto 0);
        paddr_o    : out std_logic_vector(g_addr_width-1 downto 0);
        penable_o  : out std_logic;
        pwrite_o   : out std_logic;
        pprot_o    : out std_logic_vector(2 downto 0);
        pstrb_o    : out std_logic_vector(g_data_width/8-1 downto 0);
        pready_sel_i   : in  std_logic;
        pslverr_sel_i  : in  std_logic 
    );
end entity;
